/****** Object:  StoredProcedure [dbo].[P_SNGPC_ANALISE_PENDENCIA_ENTRADA]    Script Date: 05/17/2013 14:34:03 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_SNGPC_ANALISE_PENDENCIA_ENTRADA]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_SNGPC_ANALISE_PENDENCIA_ENTRADA]
GO

/****** Object:  StoredProcedure [dbo].[P_SNGPC_ANALISE_PENDENCIA_ENTRADA]    Script Date: 05/17/2013 14:34:03 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE PROCEDURE [dbo].[P_SNGPC_ANALISE_PENDENCIA_ENTRADA] (@CD_EMP INT, @CD_FILIAL INT)
AS
BEGIN
	/*
	********************************************************************************
	********************************************************************************

									E  N  T  R  A  D  A  S
			
			--ENVIAR ENTRADAS NO REGISTRADAS E NO PENDENTES, PARA A PENDNCIA--

	********************************************************************************
	********************************************************************************
	*/

	/* LIMPAR AS TABELAS TEMPORARIAS DE USO, CASO NECESSARIO */
	BEGIN TRY
			DROP TABLE #TEMP_DIVERGENCIAS_ENTRADAS;
	END TRY
	BEGIN CATCH
	END CATCH

	SELECT
		I.CD_EMP
		, I.CD_FILIAL
		, I.CD_NF
		, C.NR_NF
		, I.CD_PROD
		, S.DS_DCB
		, P.DS_PROD
		, I.DT_ENT
		, P.FLAG_PRODUTO_CONTROLADO CONTROLADO
		, P.ANTIBIOTICO
	INTO #TEMP_DIVERGENCIAS_ENTRADAS	
	FROM EST_NF_ENT_IT I
	INNER JOIN EST_NF_ENT C ON 
			C.CD_EMP = I.CD_EMP 
		AND C.CD_FILIAL = I.CD_FILIAL 
		AND C.CD_NF = I.CD_NF
	INNER JOIN EST_PROD_EST_SNGPC S ON 
			I.CD_EMP = S.CD_EMP
		AND I.CD_PROD = S.CD_PROD
	INNER JOIN EST_PROD P ON 
			I.CD_EMP = P.CD_EMP
		AND I.CD_PROD = P.CD_PROD
	WHERE 
		I.CD_EMP = @cd_emp
		AND ((I.CD_FILIAL = @cd_filial) OR (@cd_filial = 0))
		AND	CONVERT(CHAR(10), I.DT_ENT, 112) >= (
			SELECT
				TOP 1 CONVERT(CHAR(10), RI.DT_REINICIO, 112)
			FROM EST_SNGPC_REINICIO_INVENTARIO RI
			WHERE
					RI.CD_EMP = I.CD_EMP
				AND RI.CD_FILIAL = I.CD_FILIAL
			ORDER BY
					CD_REINICIO DESC
			)
		AND NOT EXISTS (
			SELECT CD_EMP 
			FROM EST_NF_ENT_IT_EST_SNGPC_PENDENTE T 
			WHERE 
					T.CD_EMP = I.CD_EMP
				AND T.CD_FILIAL = I.CD_FILIAL 
				AND T.CD_PROD = I.CD_PROD
				AND T.CD_NF = I.CD_NF
			)
		AND NOT EXISTS (
			SELECT CD_EMP 
			FROM EST_SNGPC_ENTRADA T 
			WHERE 
					T.CD_EMP = I.CD_EMP 
				AND T.CD_FILIAL = I.CD_FILIAL 
				AND T.CD_PROD = I.CD_PROD
				AND T.CD_NF = I.CD_NF
			)
	ORDER BY CD_PROD;

	--SELECT * FROM #TEMP_DIVERGENCIAS_ENTRADAS;

	INSERT INTO EST_NF_ENT_IT_EST_SNGPC_PENDENTE
	SELECT CD_EMP, CD_FILIAL, CD_NF, CD_PROD, GETDATE() FROM #TEMP_DIVERGENCIAS_ENTRADAS;

	BEGIN TRY
			DROP TABLE #TEMP_DIVERGENCIAS_ENTRADAS;
	END TRY
	BEGIN CATCH
	END CATCH

END